# Microsoft Mail by Graph

> Note: The use of the scripts requires the PowerShell Module Microsoft.Graph.Mail

+ [Get-MGMUserInferenceClassification.ps1](./Get-MGMUserInferenceClassification.ps1)

  Relevance classification of the user's messages based on explicit designations which override inferred relevance or importance

+ [Get-MGMUserInferenceClassificationOverride.ps1](./Get-MGMUserInferenceClassificationOverride.ps1)

  Returns a set of overrides for a user to always classify messages from specific senders in certain ways: focused, or other

+ [Get-MGMUserMailFolder.ps1](./Get-MGMUserMailFolder.ps1)

  Returns user's mail folders

+ [Get-MGMUserMailFolderChildFolder.ps1](./Get-MGMUserMailFolderChildFolder.ps1)

  Returns user's mail folder child folders

+ [Get-MGMUserMailFolderChildFolderMessage.ps1](./Get-MGMUserMailFolderChildFolderMessage.ps1)

  Returns collection of messages in the mail folder child folder

+ [Get-MGMUserMailFolderChildFolderMessageAttachment.ps1](./Get-MGMUserMailFolderChildFolderMessageAttachment.ps1)

  Returns attachments from user folder child folder message

+ [Get-MGMUserMailFolderMessage.ps1](./Get-MGMUserMailFolderMessage.ps1)

  Returns collection of messages in the mail folder

+ [Get-MGMUserMailFolderMessageAttachment.ps1](./Get-MGMUserMailFolderMessageAttachment.ps1)

  Returns attachments from user folder message

+ [Get-MGMUserMailFolderMessageRule.ps1](./Get-MGMUserMailFolderMessageRule.ps1)

  Returns collection of rules that apply to the user's Inbox folder

+ [Get-MGMUserMessage.ps1](./Get-MGMUserMessage.ps1)

  Returns collection of messages in a mailbox or folder

+ [Get-MGMUserMessageAttachment.ps1](./Get-MGMUserMessageAttachment.ps1)

  Returns file and item attachments for the message

+ [Get-MGMUserMessageContent.ps1](./Get-MGMUserMessageContent.ps1)

  Returns media content for the navigation property messages from users

+ [New-MGMUserMailFolder.ps1](./New-MGMUserMailFolder.ps1)

  Creates user mail folder

+ [New-MGMUserMailFolderChildFolder.ps1](./New-MGMUserMailFolderChildFolder.ps1)

  Creates user mail folder child folder

+ [New-MGMUserMailFolderChildFolderMessage.ps1](./New-MGMUserMailFolderChildFolderMessage.ps1)

  Creates user mail folder child folder message

+ [New-MGMUserMailFolderMessage.ps1](./New-MGMUserMailFolderMessage.ps1)

  Creates user mail folder message

+ [New-MGMUserMessage.ps1](./New-MGMUserMessage.ps1)

  Creates a user message

+ [Remove-MGMUserInferenceClassification.ps1](./Remove-MGMUserInferenceClassification.ps1)

  Removes classification of the user's messages based on explicit designations which override inferred relevance or importance

+ [Remove-MGMUserMailFolder.ps1](./Remove-MGMUserMailFolder.ps1)

  Removes user mail folder

+ [Remove-MGMUserMailFolderChildFolder.ps1](./Remove-MGMUserMailFolderChildFolder.ps1)

  Removes user mail folder child folder

+ [Remove-MGMUserMailFolderChildFolderMessage.ps1](./Remove-MGMUserMailFolderChildFolderMessage.ps1)

  Removes a message in the mail folder child folder

+ [Remove-MGMUserMailFolderMessage.ps1](./Remove-MGMUserMailFolderMessage.ps1)

  Removes user mail folder message

+ [Remove-MGMUserMessage.ps1](./Remove-MGMUserMessage.ps1)

  Removes a user message

+ [Set-MGMUserMailFolder.ps1](./Set-MGMUserMailFolder.ps1)

  Updates user mail folder

+ [Set-MGMUserMailFolderChildFolder.ps1](./Set-MGMUserMailFolderChildFolder.ps1)

  Updates user mail folder child folder

+ [Set-MGMUserMailFolderChildFolderMessage.ps1](./Set-MGMUserMailFolderChildFolderMessage.ps1)

  Updates a message in the mail folder child folder

+ [Set-MGMUserMailFolderMessage.ps1](./Set-MGMUserMailFolderMessage.ps1)

  Updates user mail folder message

+ [Set-MGMUserMessage.ps1](./Set-MGMUserMessage.ps1)

  Updates a user message

## [Queries](./_QUERY_)

+ Search user mail folders
+ Search user mail folder child folders
+ Search user messages
+ Search user mail folder messages
+ Search user mail folder child folder messages